<?php
	wp_enqueue_media();
?>
<br/>
<div id="update_message"> </div>
<form class="form-horizontal" role="form"  name='map_marker' id='map_marker'>
	<h3  class="panel-heading"><?php esc_html_e('Category Image / Map Marker','ivdirectories'); ?></h3>
	<div class="row ">
		<div class="col-md-12 ">
			<table class="table table-bordered table-hover table-responsive">
				<thead>
					<tr>
						<th><?php esc_html_e('Category','ivdirectories'); ?>  </th>
						<th><?php esc_html_e('Post Type','ivdirectories'); ?>  </th>
						<th><?php esc_html_e('Map Marker','ivdirectories'); ?> </th>
						<th><?php esc_html_e('Category Image','ivdirectories'); ?> </th>
					</tr>
				</thead>
				<tbody>
					<?php
						$default_fields = array();
						$field_set=get_option('_iv_directory_url_postype' );
						if($field_set!=""){
							$default_fields=get_option('_iv_directory_url_postype' );
							}else{
							$default_fields['hotel']='Hotel';
							$default_fields['restaurant']='Restaurant';
							$default_fields['bar']='Bar';	
						}
						
						$i=1;
						foreach ( $default_fields as $field_key => $field_value ) {
							//directories
							$taxonomy = $field_key.'-category';
							$args = array(
							'orderby'           => 'name',
							'order'             => 'ASC',
							'hide_empty'        => false,
							'exclude'           => array(),
							'exclude_tree'      => array(),
							'include'           => array(),
							'number'            => '',
							'fields'            => 'all',
							'slug'              => '',
							'parent'            => '0',
							'hierarchical'      => true,
							'childless'         => false,
							'get'               => '',
							);
							$terms = get_terms($taxonomy,$args); // Get all terms of a taxonomy
							if ( $terms && !is_wp_error( $terms ) ) :
							foreach ( $terms as $term ) {  ?>
							<tr>
								<td>
									<?php echo strtoupper($term->name);  ?>
									<input type="hidden" name="<?php echo esc_html($term->slug);?>" id="<?php echo esc_html($term->slug);?>" value="<?php echo esc_html($term->term_id);?>">
								</td>
								<td><?php echo esc_html($field_value);?>
								</td>
								<td>
									<div id="marker_<?php echo esc_html($term->term_id);?>" class="col-md-2">
										<?php
											$marker = get_option('_cat_map_marker_'.$term->term_id);
											if($marker!=''){
												echo wp_get_attachment_image($marker);
											}else{ ?>
											<img  width="20px" src="<?php echo  wp_iv_directories_URLPATH."/assets/images/map-marker/map-marker.png";?>">
											<?php
											}
										?>
									</div>
									<button type="button" onclick="change_marker_image('<?php echo esc_html($term->term_id);?>');"  class="btn btn-success btn-xs"><?php esc_html_e('Change Image','ivdirectories'); ?></button>
								</td>
								<td>
									<div id="cate_<?php echo esc_html($term->term_id);?>" class="">
										<?php
											$marker = get_option('_cate_main_image_'.$term->term_id);
											if($marker!=''){
												echo wp_get_attachment_image($marker);
											}else{ ?>
											<?php
											}
										?>
									</div>
									<br/>
									<button type="button" onclick="change_cate_image('<?php echo esc_html($term->term_id);?>');"  class="btn btn-success btn-xs"><?php esc_html_e('Set Image','ivdirectories'); ?></button>
								</td>
							</tr>
							<?php
							}
							endif;
						}
					?>
				</tbody>
			</table>
		</div>
	</div>
</form>